package gov.va.vamf.scheduling.varutility.domain;


import org.springframework.data.mongodb.core.mapping.Document;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.Collections;

@Document(collection="clinical-services")
@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(namespace = Namespace.VarUtility)
public class ClinicalServices extends DomainBaseObject{

    @XmlElement
    String name;

    @XmlElement
    StopCodes stopCodes;

    @XmlElement
    Integer submittedRequestLimit;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public StopCodes getStopCodes() {
        Collections.sort(stopCodes);
        return stopCodes;
    }

    public void setStopCodes(StopCodes stopCodes) {
        this.stopCodes = stopCodes;
    }

    public Integer getSubmittedRequestLimit() {
        return submittedRequestLimit;
    }

    public void setSubmittedRequestLimit(Integer submittedRequestLimit) {
        this.submittedRequestLimit = submittedRequestLimit;
    }
}
